static char *mailmsg_id =
"@(#)Copyright (c) KOUNO Takashi -- Mailmsg -- ( IPmsg helper soft ) Ver 0.71";

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <limits.h>
#include <netdb.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#define MAILMSG_VERSION "0.71"

#define IPMSG_VERSION		0x001
#define IPMSG_PORT			0x979
#define IPMSG_REVERSEICON	0x100

#define IPMSG_BR_ENTRY		0x00000001
#define IPMSG_BR_EXIT		0x00000002
#define IPMSG_ANSENTRY		0x00000003
#define IPMSG_BR_ISGETLIST	0x00000010
#define IPMSG_OKGETLIST		0x00000011
#define IPMSG_GETLIST		0x00000012
#define IPMSG_ANSLIST		0x00000013
#define IPMSG_SENDMSG		0x00000020
#define IPMSG_RECVMSG		0x00000021

#define IPMSG_SENDCHECKOPT	0x00000100
#define IPMSG_SECRETOPT		0x00000200
#define IPMSG_BROADCASTOPT	0x00000400
#define IPMSG_NOPOPUPOPT	0x00000800
#define IPMSG_PASSWORDOPT	0x00008000
#define IPMSG_NOLOGOPT 		0x00020000
#define IPMSG_NOADDLISTOPT  0x00080000

#define UDP_BUF			8192

#define GET_MODE( command )	( command & 0x000000ff )
#define GET_OPT( command )	( command & 0x0000ff00 )

#define FAIL	0
#define MAXLEN 0x1ff
#define MAXBUFLEN	0x01ff
#define MAXHEADDERLINE	0x00ff
#define MAXHEADDERLEN	0x01ff
#define MAXBODYLEN	0x01ff
#define MAXBODYLINE	0x00ff

#define DEFAULT_HEADDER "From:"
#define DEFAULT_MESSAGE "[͂܂B"
#define NOTEXIST "Not Exist the Headder"
#define BODY_START "--- { ---\n"
#define ENV_LOGNAME "LOGNAME"
#define EDITOR_ENV_NAME "EDITOR"
#define EDITOR "vi"
#define SENDFILE_ENV_NAME "MAILMSGSFILE"
#define SENDFILE "/tmp/mailmsg.send"

// \Pbg쐬s̃gC񐔂ƃgCԂ̃EFCg(sec)
#define MAX_RETRY 10
#define RETRY_WAIT 1

void make_msg(char *buf, int command, char *msg);
void get_headder(char **headder, char *body);
char *get_target(char *msg, const char *target, char **headder);
char *get_real(char *str);
void get_all(char *msg);
void print_usage(void);
void dummy_function(char *dummy,...);

#if defined(DEBUG)
#define debug	fprintf(stderr, "Line %d\n", __LINE__)
#define d_printf printf
#else
#define debug
#define d_printf dummy_function
#endif

int HeadderLine = 0;
int ipmsg_port;
int body_request = 0;
int body_line = 0;
int direct_msg = 0;
char *g_editor = NULL;
char *g_sendfile = NULL;

int main(int argc, char *argv[])
{
    int sd, lp;
    struct sockaddr_in saddr;
    struct hostent *host;
    char *buf, *work, *sendbuf, *msg;
    long addr;
    char **headder;
    char *body;
    int opt_flag = IPMSG_NOLOGOPT;
    int nBufLen;
    int nBodyLen;
    char *ptr;
    char *sendhost;
    int cpid;
    int statusp;

    ipmsg_port = IPMSG_PORT;

    /* ̉ - nCt1ɂ1̃o[W */
    for (; argc > 1 && argv[1][0] == '-'; argv++, argc--) {
        switch (argv[1][1]) {
        case 'l':
        case 'L':
            opt_flag &= ~IPMSG_NOLOGOPT;
            break;
        case '?':
        case 'h':
        case 'H':
            print_usage();
            exit(0);
        case 'p':
        case 'P':
            ipmsg_port = strtol(&argv[1][2], &ptr, 0);
            d_printf("PORT %d(%s)\n", ipmsg_port, &argv[1][0]);
            if (ipmsg_port == 0)
                ipmsg_port = IPMSG_PORT;
            break;
        case 'b':
        case 'B':
            body_request = strtol(&argv[1][2], &ptr, 0);
            d_printf("BODY %d(%s) LINE PRINT\n", body_request, &argv[1][0]);
            if (body_request > MAXBODYLINE) {
                body_request = MAXBODYLINE;
            }
            break;
        case 's':
        case 'S':
            opt_flag |= IPMSG_SECRETOPT;
            break;
        case 'w':
        case 'W':
            opt_flag |= IPMSG_PASSWORDOPT | IPMSG_SECRETOPT;
            break;
        case 'd':
        case 'D':
            direct_msg = 1;
            break;
        case 'c':
        case 'C':
            opt_flag |= IPMSG_SENDCHECKOPT;
            break;
        case 'e':
        case 'E':
            if (argv[1][2] != '\0') {
                g_editor = &argv[1][2];
            } else if (!(g_editor = getenv(EDITOR_ENV_NAME))) {
                g_editor = EDITOR;
            }
            break;
        case 'f':
        case 'F':
            if (argv[1][2] != '\0') {
                g_sendfile = &argv[1][2];
            } else if (!(g_sendfile = getenv(SENDFILE_ENV_NAME))) {
                g_sendfile = SENDFILE;
            }
        default:
            break;
        }
    }

    debug;
    
    /* -e w莞̃t@CGfBbg */
    if (g_editor) {
        if (!g_sendfile) {
            if (!(g_sendfile = getenv(SENDFILE_ENV_NAME))) {
                g_sendfile = SENDFILE;
            }
        }
        if ((cpid = fork()) == 0) {
            execlp(g_editor, g_editor, g_sendfile, NULL);
            perror("Can't exec editor");
            exit(0);
        }
        if (cpid == -1) {
            perror("Can't create process");
            exit(0);
        }
        wait(&statusp);
        printf("Send message OK?[y/n]\n");
        if (getchar() != 'y') {
            printf("Not send\n");
            exit(0);
        }
    }
    debug;

    /* {fBAP[g */
    if (body_request) {
        if (!(body = malloc(UDP_BUF))) {
            perror("Body Buffer Allocate Error in MailMsg");
            return -1;
        }
    } else {
        body = NULL;
    }

    /* bZ[WAP[g */
    if ((msg = malloc(UDP_BUF)) == NULL) {
        perror("MSG Buffer Allocate Error\n");
        return -1;
    }
    msg[0] = '\0';

    /* e|obt@AP[g */
    if ((buf = malloc(UDP_BUF)) == NULL) {
        perror("Buffer Allocate Error in MailMsg");
        return -1;
    }
    /* Mobt@AP[g */
    if ((sendbuf = malloc(UDP_BUF)) == NULL) {
        perror("Send Buffer Allocate Error in MailMsg");
        return -1;
    }
    if ((work = malloc(UDP_BUF)) == NULL) {
        perror("Work Buffer Allocate Error in MailMsg");
        return -1;
    }
    /* wb_obt@AP[g */
    if ((headder = malloc(sizeof(char *) * MAXHEADDERLINE)) == NULL) {
        perror("Headder Buffer Allocate Error in MailMsg");
        return -1;
    }
    for (lp = 0; lp < MAXHEADDERLINE; lp++) {
        if ((headder[lp] = malloc(MAXHEADDERLEN)) == NULL) {
            fprintf(stderr, "Headder(%d) Buffer Allocate Error in MailMsg", lp);
            perror(NULL);
            return -1;
        }
    }

    /* ̕sx */
    if (argc < 2) {
        return fprintf(stderr, "NOT ENOUGH PARAMETER MUST NEED 1 -> mailmsg hostname\n"), -1;
    }
    /* wb_Ǝwʃ{fB̎擾 */
    if (direct_msg) {
        get_all(msg);
        goto SEND;
    } else {
        get_headder(headder, body);
    }

    if (argc == 2 && !direct_msg) {
        debug;
        get_target(buf, DEFAULT_HEADDER, headder);
        sprintf(msg, "%s\n\n         %s\n", buf, DEFAULT_MESSAGE);
    }
    debug;

    /* wwb_̔ */
    sendhost = argv[1];
    for (; argc > 2 && !direct_msg; argc--,argv++) {
        char tmp[MAXHEADDERLEN];
        get_target(tmp, argv[2], headder);
        if (strcmp(tmp, NOTEXIST) != 0) { /* wwb_݂͑邩H */
            if (tmp) {
                sprintf(work, "%s\n  %s", argv[2], tmp); /* */
                sprintf(buf, "%s%s\n", buf, work);
            }
        }
    }
    sprintf(msg, "%s\n\n%s\n", DEFAULT_MESSAGE, buf);
    argv[1] = sendhost;

    debug;
    /* {fB̐ڑ */
    if (body_request) {
        nBufLen = strlen(msg);
        nBodyLen = strlen(body);
        if (nBufLen + nBodyLen >= UDP_BUF) {
            if (nBufLen <= UDP_BUF) {
                body[UDP_BUF - nBufLen] = '\0';
            }
        }
        strcat(msg, body);
    }
    msg[UDP_BUF - 100] = '\0';

 SEND:
    /* \Pbg̍쐬Ə */
    for (lp = 0; lp < MAX_RETRY; lp++) {
        if ((sd = socket(AF_INET, SOCK_DGRAM, 0)) != -1) {
            break;
        }
        sleep(RETRY_WAIT);
    }
    if (sd == -1) {
        perror("Can't create socket");
        return -1;
    }

    /* lɑ΂鑗M */
    for (; argc > 1; argc--,argv++) {
        if ((host = (struct hostent *) gethostbyname(argv[1])) != NULL) {
            addr = *(long *) host->h_addr;
        } else {
            if (ptr = strrchr(argv[1], '[')) {
                argv[1] = ptr + 1;
                if (ptr = strrchr(argv[1], ']')) {
                    *ptr = '\0';
                }
            }
            if ((addr = inet_addr(argv[1])) == -1) {
                fprintf(stderr, "invalid hostname(%s) : ", argv[1]);
                perror(NULL);
                continue;
            }
        }

        memset(&saddr, 0, sizeof(saddr));
        saddr.sin_family = AF_INET;
        saddr.sin_port = htons(ipmsg_port);
        saddr.sin_addr.s_addr = addr;

        /* MoCg̍쐬 */
        make_msg(sendbuf, IPMSG_SENDMSG | opt_flag | IPMSG_NOADDLISTOPT, msg);

        /* M */
        if (sendto(sd, sendbuf, strlen(sendbuf) + 1, 0,
                   (struct sockaddr *) &saddr, sizeof(saddr)) == -1) {
            fprintf(stderr, "Sendto Err(%s) : ", argv[1]);
            perror(NULL);
        }
        if (!direct_msg){
            break;
        }
    }

    return 0;
}

/* obZ[W쐬[` */
void make_msg(char *buf, int command, char *msg)
{
    long packet_no;
    char username[MAXBUFLEN];
    char hostname[MAXBUFLEN];

    if (gethostname(hostname, sizeof(hostname)) == -1) {
        strcpy(hostname, "Unknow host");
    }
    if (direct_msg) {
        if (!getenv(ENV_LOGNAME)) {
            strcpy(username, "Unknown user");
        } else {
            strcpy(username, getenv(ENV_LOGNAME));
        }
    }
    packet_no = time(&packet_no) + ((long) getpid() << 16);

    if (!direct_msg) {
        sprintf(buf, "%d:%d:%s:%s:%d:%s", IPMSG_VERSION, packet_no, "MailMsg", hostname, command, msg ? msg : "");
    } else {
        sprintf(buf, "%d:%d:%s:%s:%d:%s", IPMSG_VERSION, packet_no, username, hostname, command, msg ? msg : "");
    }
}

/* wb_o[` */
void get_headder(char **headder, char *body)
{
    char buf[MAXBODYLEN];
    int buflen, bodylen;
    int lp;
    FILE *fp = stdin;

    /* ǂݍ݃t@C͎w? */
    if (g_sendfile) {
        if (!(fp = fopen(g_sendfile, "r"))) {
            fp = stdin;
        }
    }
    /* wb_o */
    while (fgets(headder[HeadderLine++], MAXHEADDERLEN, fp)) {
        /* 1s̒`FbN */
        if (strlen(headder[HeadderLine - 1]) >= MAXHEADDERLEN - 1) {
            headder[HeadderLine - 1][MAXHEADDERLEN - 1] = '\0';
            while (getchar() != '\n');
        }
        if (headder[HeadderLine - 1][0] == '\n') {
            break;
        }
        /* s̃`FbN */
        if (HeadderLine > MAXHEADDERLINE) {
            while (fgets(headder[HeadderLine], MAXHEADDERLEN, fp)){
                if (headder[HeadderLine - 1][0] == '\n') {
                    break;
                }
            }
            break;
        }
    }
    /* body o[eB */
    if (body) {
        strcpy(body, BODY_START);
        for (lp = 0; fgets(buf, MAXBODYLEN, fp) && lp < body_request; lp++) {
            buflen = strlen(buf);
            bodylen = strlen(body);
            if (buflen + bodylen >= UDP_BUF) {
                break;
            }
            strcat(body, buf);
        }
    }
    /* pipe I */
    while (fgets(buf, MAXBODYLEN, fp));
    if (fp != stdin) {
        fclose(fp);
    }
}

/* wb_񒊏o[` */
char *
get_target(char *ret, const char *target, char **headder)
{
    char str[MAXHEADDERLEN];
    char field_name[MAXBUFLEN], *field, *filed2;
    int flag, len, lp, ln = 0;

    while (ln < HeadderLine) {
        /* 1s */
        strncpy(str, headder[ln++], MAXHEADDERLEN);

        /* ':'܂܂ĂȂΎ̍s */
        if ((field = strchr(str, ':')) == NULL) {
            continue;
        }
        /* ̍s̐擪 SPACE,TABłΎ̍sǉ */
        while (headder[ln][0] == '\t' ||
               headder[ln][0] == ' ') {
            if ((int) (strlen(str) + strlen(headder[ln])) > MAXHEADDERLEN)
                break;
            strcat(str, headder[ln++]);
        }

        field++;                /* filed̒l ':'ȍ~Ƃ */
        len = strlen(field);

        /* TABAsSpaceɒu */
        for (lp = 0; lp < len; lp++) {
            if (field[lp] == '\t' ||
                field[lp] == '\r' ||
                field[lp] == '\n') {
                field[lp] = ' ';
            }
        }

        /* wb_ڂ̔F */
        strncpy(field_name, str, field - str);
        field_name[field - str] = '\0';

        /* wb_ڂtargetƓ΂̍ڂ̓eԂ */
        if (strcmp(field_name, target) == 0) {
            if (strcpy(ret, field) == NULL) {
                strcpy(ret, "Unknown because strcpy error");
            }
            break;
        }
    }

    /* w^[Qbg݂Ȃꍇ */
    if (ln >= HeadderLine) {
        strcpy(ret, NOTEXIST);
    }
    debug;
#if !defined(MIME)
    get_real(ret);
#endif
    return ret;
}

char *
get_real(char *str)
{
    char *ret = str, *work;
    if ((ret = strchr(str, '<')) != NULL) {
        work = strchr(++ret, '>');
        *work = '\0';
        strcpy(str, ret);
#if(1)
    } else {
        if ((work = strchr(str, '(')) != NULL) {
            debug;
            *work = '\0';
            ret = str;
        }
#endif
    }
    return ret;
}

/* So */
void get_all(char *msg)
{
    char buf[MAXLEN];
    FILE *fp = stdin;

    if (g_sendfile) {
        if (!(fp = fopen(g_sendfile, "r"))) {
            fp = stdin;
        }
    }
    while (fgets(buf, MAXLEN - 1, fp)) {
        buf[MAXLEN - 1] = '\0';
        if (strlen(buf) + strlen(msg) > UDP_BUF - 100) {
            break;
        }
        strcat(msg, buf);
    }

    if (fp != stdin) {
        fclose(fp);
    }
}

void dummy_function(char *dummy,...)
{
}

void print_usage(void)
{
    printf("MailMsg(biff tool) Version %s\n", MAILMSG_VERSION);
    printf("Usage:\n");
    printf("mailmsg [-option] Hostname DisplayHeadder:\n");
    printf("Option:\n");
    printf("\t-l IPMSG loging option\n");
    printf("\t-d Command line IP Messenger sender(Direct mode)\n");
    printf("\t-s Secret operate option\n");
    printf("\t-w Secret & Lock operate option\n");
    printf("\t-c Send Check operate option(Can't recive MailMsg)\n");
    printf("\t-p Send port\n");
    printf("\t-b Send body line\n");
    printf("\t-e Edit file before send(Not use stdin)\n");
    printf("\t-f Send message in file(Not use stdin)\n");
    printf("\t-h Print this usage(? is same)\n");
    printf("Example: ~/.forward file\n");
    printf("--- begin ---\n");
    printf("\"| nkf -m -s | mailmsg -p2000 -b50 hogehoge From: Subject:\"\n");
    printf("--- end ---\n");
}
